* Create our own CDS indices from the merged CMA+TRACE+FISD file
* --------------------------------------------------------------

* STEP 1: CALCULATE AVERAGE RATING AND VALUE OF SENIOR DEBT WITH MATURITY >=1 YEAR FOR EACH COMPANY-DATE 
* ------------------------------------------------------------------------------------------------------

clear
use cma_trace_fisd
keep ticker complete_cusip price offering_amt date maturity security_level sp moodys amount_outstanding 
keep if inlist(security_level,"SEN","SENS","SS")
drop security_level

ge matyears=(maturity-date)/365
drop if matyears<1
so complete_cusip date
fillin complete_cusip date

ge mrating=1 if moodys=="Aaa"
replace mrating=2 if inlist(moodys,"Aa1","Aa2","Aa3")
replace mrating=3 if inlist(moodys,"A1","A2","A3")
replace mrating=4 if inlist(moodys,"Baa1","Baa2","Baa3")
replace mrating=5 if inlist(moodys,"Ba1","Ba2","Ba3")
replace mrating=6 if inlist(moodys,"B1","B2","B3")
replace mrating=7 if substr(moodys,1,1)=="C"

replace mrating=1 if moodys=="" & inlist(sp,"AAA")
replace mrating=2 if moodys=="" & inlist(sp,"AA+","AA","AA-")
replace mrating=3 if moodys=="" & inlist(sp,"A+","A","A-")
replace mrating=4 if moodys=="" & inlist(sp,"BBB+","BBB","BBB-")
replace mrating=5 if moodys=="" & inlist(sp,"BB+","BB","BB-")
replace mrating=6 if moodys=="" & inlist(sp,"B+","B","B-")
replace mrating=7 if moodys=="" & substr(sp,1,1)=="C" | substr(sp,1,1)=="D"

so complete_cusip date
for any price amount_outstanding: replace X=X[_n-1] if complete_cusip==complete_cusip[_n-1] & X==. & X[_n-1]~=.
for any ticker:  replace X=X[_n-1] if complete_cusip==complete_cusip[_n-1] & X=="" & X[_n-1]~=""
for any mrating: replace X=X[_n-1] if complete_cusip==complete_cusip[_n-1] & X==.  & X[_n-1]~=.

drop if date>maturity
ge year=year(date)
ge month=month(date)
ge day=day(date)
replace price=. if complete_cusip=="38146FAA9" & year==2008 & month==12 & day==17
so complete_cusip date
drop if mrating==.

so ticker complete_cusip date
ge val=price[_n-1]*amount_outstanding[_n-1] if complete_cusip==complete_cusip[_n-1]
ge lagrating=mrating[_n-1] if complete_cusip==complete_cusip[_n-1]
egen valseniorall=sum(val), by(ticker date)
egen check=sum(val/valseniorall), by(ticker date)
drop if check==0
egen meanrating=sum(lagrating*val/valseniorall) if val~=. & valseniorall~=., by(ticker date)
tab mrating [aw=val]

so ticker date
drop if date==date[_n-1]
keep ticker date meanrating valseniorall year month day
drop if ticker==""
replace meanrating=. if meanrating==0
save alldebt_values3, replace


* STEP 2: CALCULATE AVERAGE VALUE-WEIGHTED 1- AND 2-DAY CDS CHANGES BY DATE, FOR EACH RATINGS GROUP
* -------------------------------------------------------------------------------------------------

clear
use c:\jobcd\qe\kevin\cma_trace_fisd
keep if cds_5y~=. | cds_10y~=.
drop if ticker=="AIG"
so ticker date
drop if ticker==ticker[_n-1] & date==date[_n-1]
drop if bad==1

drop _m
mer ticker date using alldebt_values3
drop if _m==2 | _m==1
drop _m
so ticker date

ge d2cds5=cds_5y[_n+1]-cds_5y[_n-1] if ticker[_n+1]==ticker[_n-1]
ge dcds5=cds_5y[_n]-cds_5y[_n-1] if ticker[_n]==ticker[_n-1]
ge d2cds10=cds_10y[_n+1]-cds_10y[_n-1] if ticker[_n+1]==ticker[_n-1]
ge dcds10=cds_10y[_n]-cds_10y[_n-1] if ticker[_n]==ticker[_n-1]
replace d2cds10=. if abs(d2cds10)>10000 & d2cds10~=.
replace d2cds5=. if abs(d2cds5)>10000 & d2cds5~=.
replace dcds10=. if abs(dcds10)>10000 & dcds10~=.
replace dcds5=. if abs(dcds5)>10000 & dcds5~=.

ge qe=1      if year==2008 & month==11 & day==25
replace qe=2 if year==2008 & month==12 & day==1
replace qe=3 if year==2008 & month==12 & day==16
replace qe=4 if year==2009 & month==1  & day==28
replace qe=5 if year==2009 & month==3  & day==18
replace qe=6 if year==2010 & month==8  & day==10
replace qe=7 if year==2010 & month==9  & day==21

gen rmeanrating=round(meanrating)
table qe rmeanrating  [aw=valseniorall], c(mean d2cds5)
table qe rmeanrating  [aw=valseniorall], c(mean d2cds10)
table qe rmeanrating  [aw=valseniorall], c(mean dcds5)
table qe rmeanrating  [aw=valseniorall], c(mean dcds10)

for num 1/7: egen m5X=wtmean(dcds5) if rmeanrating==X, weight(valseniorall) by(date)
for num 1/7: egen mm5X=max(m5X), by(date)
for num 1/7: egen m10X=wtmean(dcds10) if rmeanrating==X, weight(valseniorall) by(date)
for num 1/7: egen mm10X=max(m10X), by(date)
for num 1/7: egen d2m5X=wtmean(d2cds5) if rmeanrating==X, weight(valseniorall) by(date)
for num 1/7: egen d2mm5X=max(d2m5X), by(date)
for num 1/7: egen d2m10X=wtmean(d2cds10) if rmeanrating==X, weight(valseniorall) by(date)
for num 1/7: egen d2mm10X=max(d2m10X), by(date)

so date ticker
drop if date==date[_n-1]
drop if year<2008
drop if year==2010 & month>=10

ge dqe1=inlist(qe,1,2,3,4,5)==1
ge dqe1lag=inlist(qe[_n-1],1,2,3,4,5)==1
ge dqe2=inlist(qe,6,7)==1
ge dqe2lag=inlist(qe[_n-1],1,2)==1
ge d2qe1=inlist(qe,1,2,3,4,5)==1
ge d2qe2=inlist(qe,6,7)==1


* Testing significance of 1-day changes
foreach z in mm51 mm52 mm53 mm54 mm55 mm56 mm57  mm101 mm102 mm103 mm104 mm105 mm106 mm107 {
	reg `z' dqe1 dqe1lag dqe2 dqe2lag if inlist(year,2008,2009,2010)==1, robust
	test dqe1=0
	test dqe1+dqe1lag=0
	test dqe2=0
	test dqe2+dqe2lag=0
}

* Testing significance of 2-day changes, use 2-day changes, non-overlapping
so date
ge n=_n
ge timeblock=n if n==2*int(n/2)
ge use=0
replace use=1 if timeblock~=.
replace use=1 if inlist(qe,1,2,3,4,5,6,7)==1
replace use=0 if qe[_n+1]~=.
replace use=0 if qe[_n-1]~=.

for num 1/7: reg d2mm10X d2qe1 d2qe2 if use==1, robust
for num 1/7: reg d2mm5X d2qe1 d2qe2 if use==1, robust
